//---------------------------------------------------------------------------
// Burner - Arcade emulator interface
// Copyright (c) 2002 Dave (www.finalburn.com), all rights reserved.

// This refers to all code except where stated otherwise
// (e.g. unzip and zlib code)

// You can use, modify and redistribute this code freely as long as you
// don't do so commercially. This copyright notice must remain with the code.
// If your program uses this code, you must either distribute or link to the
// source code. If you modify or improve this code, you must distribute
// the source code improvements.

// Dave
// Homepage: www.finalburn.com
// E-mail:  dave@finalburn.com
//---------------------------------------------------------------------------

// Main module

#include "app.h"
#include <tchar.h>

//#define APP_DEBUG_LOG // log debug messages to zzd.txt
static char *szCmdLine="";
int nAppVirtualFps=600; // App fps * 10
int nUseSysMemory=-1;
int bAppBassFilter=0;
char szAppBurnVer[16]="";
extern void AudioInit();
extern "C" int dprintf(char *format, ...);
extern unsigned int AnalogSpeed;

// Main program entry point
int SegaMain(std::string game)
{
  dprintf("BurnLibInit\n");
  BurnLibInit();
  dprintf("AudioInit\n");
  AudioInit();
  dprintf("DrvInit\n");
  bool gameValid = false;
  if (_tcscmp(game.c_str(), "aburner") == 0) {
	  if(DrvInit(0)) return 0;
	  AnalogSpeed = 10000;
  }
  if (_tcscmp(game.c_str(), "aburner2") == 0) {
	  if(DrvInit(1)) return 0;
	  AnalogSpeed = 10000;
  }
  if (_tcscmp(game.c_str(), "gforce2") == 0) {
	  if(DrvInit(2)) return 0;
	  AnalogSpeed = 0;
  }
  if (_tcscmp(game.c_str(), "gforce2j") == 0) {
	  if(DrvInit(3)) return 0;
	  AnalogSpeed = 0;
  }
  if (_tcscmp(game.c_str(), "pdrift") == 0) {
	  if(DrvInit(6)) return 0;
	  AnalogSpeed = 0;
  }
  if (_tcscmp(game.c_str(), "pdriftj") == 0) {
	  if(DrvInit(7)) return 0;
	  AnalogSpeed = 0;
  }
  if (_tcscmp(game.c_str(), "rchase") == 0) {
	 if(DrvInit(8)) return 0;
	 AnalogSpeed = 0;
  }
  if (_tcscmp(game.c_str(), "thndrbld") == 0) {
	  if(DrvInit(11)) return 0;
	  AnalogSpeed = 0;
  }
  
  dprintf("MediaInit\n");
  MediaInit();
  dprintf("RunMessageLoop\n");
  RunMessageLoop(); // Run the application message loop
  return 0;
}
